<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwbehaviors="urn:WebWorks-Behaviors-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl wwfilesext wwmode wwfiles wwdoc wwbehaviors wwproject wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterDependsType" />
 <xsl:param name="ParameterBehaviorsType" />
 <xsl:param name="ParameterType" />


 <xsl:namespace-alias stylesheet-prefix="wwtoc" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />
 <xsl:key name="wwfiles-files-by-documentid" match="wwfiles:File" use="@documentID" />
 <xsl:key name="wwbehaviors-paragraphs-by-id" match="wwbehaviors:Paragraph" use="@id" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <xsl:variable name="GlobalDocumentNamespace" select="'urn:WebWorks-Document-Schema'" />


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Iterate input documents -->
   <!--                         -->
   <xsl:for-each select="$GlobalInput[1]">
    <xsl:variable name="VarFilesByType" select="key('wwfiles-files-by-type', $ParameterDependsType)" />

    <xsl:value-of select="wwprogress:Start(count($VarFilesByType))" />

    <xsl:for-each select="$VarFilesByType">
     <xsl:variable name="VarFilesDocument" select="." />

     <xsl:value-of select="wwprogress:Start(1)" />

     <xsl:for-each select="$GlobalFiles[1]">
      <xsl:variable name="VarBehaviorsDocument" select="key('wwfiles-files-by-documentid', $VarFilesDocument/@documentID)[@type = $ParameterBehaviorsType]" />

      <!-- Up to date? -->
      <!--             -->
      <xsl:variable name="VarPath" select="wwfilesystem:Combine(wwfilesystem:GetDirectoryName($VarFilesDocument/@path), concat(translate($ParameterType, ':', '_'),'.xml'))" />
      <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarPath, $GlobalProject/wwproject:Project/@ChangeID, $VarFilesDocument/@groupID, $VarFilesDocument/@documentID, $GlobalActionChecksum)" />
      <xsl:if test="not($VarUpToDate)">
       <xsl:variable name="VarResultAsXML">
        <!-- Load document -->
        <!--               -->
        <xsl:variable name="VarDocument" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesDocument/@path)" />
        <xsl:variable name="VarBehaviors" select="wwexsldoc:LoadXMLWithoutResolver($VarBehaviorsDocument/@path)" />

        <xsl:call-template name="Document">
         <xsl:with-param name="ParamDocument" select="$VarDocument" />
         <xsl:with-param name="ParamDocumentID" select="$VarFilesDocument/@documentID" />
         <xsl:with-param name="ParamBehaviors" select="$VarBehaviors" />
        </xsl:call-template>
       </xsl:variable>
       <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
       <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarPath, 'utf-8', 'xml', '1.0', 'yes')" />
      </xsl:if>

      <wwfiles:File path="{$VarPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarPath)}" projectchecksum="{$GlobalProject/wwproject:Project/@ChangeID}" groupID="{$VarFilesDocument/@groupID}" documentID="{$VarFilesDocument/@documentID}" actionchecksum="{$GlobalActionChecksum}">
       <wwfiles:Depends path="{$VarBehaviorsDocument/@path}" checksum="{$VarBehaviorsDocument/@checksum}" groupID="{$VarBehaviorsDocument/@groupID}" documentID="{$VarBehaviorsDocument/@documentID}" />
       <wwfiles:Depends path="{$VarFilesDocument/@path}" checksum="{$VarFilesDocument/@checksum}" groupID="{$VarFilesDocument/@groupID}" documentID="{$VarFilesDocument/@documentID}" />
      </wwfiles:File>

     </xsl:for-each>
     <xsl:value-of select="wwprogress:End()" />
    </xsl:for-each>

    <xsl:value-of select="wwprogress:End()" />
   </xsl:for-each>

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="Document">
  <xsl:param name="ParamDocument" />
  <xsl:param name="ParamDocumentID" />
  <xsl:param name="ParamBehaviors" />

  <wwtoc:TableOfContents version="1.0">
   <xsl:apply-templates select="$ParamDocument/wwdoc:Document/wwdoc:Content/*" mode="wwmode:toc">
    <xsl:with-param name="ParamDocument" select="$ParamDocument" />
    <xsl:with-param name="ParamDocumentID" select="$ParamDocumentID" />
    <xsl:with-param name="ParamTrackDocumentPosition" select="true()" />
    <xsl:with-param name="ParamBehaviors" select="$ParamBehaviors" />
   </xsl:apply-templates>
  </wwtoc:TableOfContents>
 </xsl:template>


 <xsl:template match="wwdoc:Table" mode="wwmode:toc">
  <xsl:param name="ParamDocument" />
  <xsl:param name="ParamDocumentID" />
  <xsl:param name="ParamTrackDocumentPosition" />
  <xsl:param name="ParamBehaviors" />

  <xsl:for-each select="wwdoc:Caption[1]">
   <xsl:apply-templates select="./*" mode="wwmode:toc">
    <xsl:with-param name="ParamDocument" select="$ParamDocument" />
    <xsl:with-param name="ParamDocumentID" select="$ParamDocumentID" />
    <xsl:with-param name="ParamTrackDocumentPosition" select="false()" />
    <xsl:with-param name="ParamBehaviors" select="$ParamBehaviors" />
   </xsl:apply-templates>
  </xsl:for-each>

  <xsl:for-each select="wwdoc:TableHead | wwdoc:TableBody | wwdoc:TableFoot">
   <xsl:for-each select="wwdoc:TableRow">
    <xsl:for-each select="wwdoc:TableCell">
     <xsl:apply-templates select="./*" mode="wwmode:toc">
      <xsl:with-param name="ParamDocument" select="$ParamDocument" />
      <xsl:with-param name="ParamDocumentID" select="$ParamDocumentID" />
      <xsl:with-param name="ParamTrackDocumentPosition" select="false()" />
      <xsl:with-param name="ParamBehaviors" select="$ParamBehaviors" />
     </xsl:apply-templates>
    </xsl:for-each>
   </xsl:for-each>
  </xsl:for-each>
 </xsl:template>


 <xsl:template match="wwdoc:Frame" mode="wwmode:toc">
  <xsl:param name="ParamDocument" />
  <xsl:param name="ParamDocumentID" />
  <xsl:param name="ParamTrackDocumentPosition" />
  <xsl:param name="ParamBehaviors" />

  <!-- Do not recurse frames -->
  <!--                       -->
 </xsl:template>


 <xsl:template match="wwdoc:Paragraph" mode="wwmode:toc">
  <xsl:param name="ParamDocument" />
  <xsl:param name="ParamDocumentID" />
  <xsl:param name="ParamTrackDocumentPosition" />
  <xsl:param name="ParamBehaviors" />

  <xsl:variable name="VarParagraph" select="." />

  <xsl:call-template name="Paragraph">
   <xsl:with-param name="ParamDocument" select="$ParamDocument" />
   <xsl:with-param name="ParamDocumentID" select="$ParamDocumentID" />
   <xsl:with-param name="ParamParagraph" select="$VarParagraph" />
   <xsl:with-param name="ParamTrackDocumentPosition" select="$ParamTrackDocumentPosition" />
   <xsl:with-param name="ParamBehaviors" select="$ParamBehaviors" />
  </xsl:call-template>
 </xsl:template>


 <xsl:template name="Paragraph">
  <xsl:param name="ParamDocument" />
  <xsl:param name="ParamDocumentID" />
  <xsl:param name="ParamParagraph" />
  <xsl:param name="ParamTrackDocumentPosition" />
  <xsl:param name="ParamBehaviors" />

  <!-- Record position -->
  <!--                 -->
  <xsl:variable name="VarPosition" select="position()" />

  <!-- Get rule -->
  <!--          -->
  <xsl:variable name="VarContextRule" select="wwprojext:GetContextRule('Paragraph', $ParamParagraph/@stylename, $ParamDocumentID, $ParamParagraph/@id)" />

  <!-- Generate output? -->
  <!--                  -->
  <xsl:variable name="VarGenerateOutput" select="$VarContextRule/wwproject:Options/wwproject:Option[@Name = 'generate-output']/@Value" />
  <xsl:if test="(string-length($VarGenerateOutput) = 0) or ($VarGenerateOutput != 'false')">
   <!-- In TOC? -->
   <!--         -->
   <xsl:variable name="VarTOCLevel" select="$VarContextRule/wwproject:Options/wwproject:Option[@Name = 'toc-level']/@Value" />
   <xsl:if test="($VarTOCLevel != 'none') and ($VarTOCLevel &gt; 0)">
    <!-- Create entry -->
    <!--              -->
    <wwtoc:Entry>
     <xsl:attribute name="id">
      <xsl:value-of select="$ParamParagraph/@id" />
     </xsl:attribute>
     <xsl:attribute name="documentID">
      <xsl:value-of select="$ParamDocumentID" />
     </xsl:attribute>
     <xsl:attribute name="level">
      <xsl:value-of select="$VarTOCLevel" />
     </xsl:attribute>
     <xsl:if test="$ParamTrackDocumentPosition">
      <xsl:attribute name="documentposition">
       <xsl:value-of select="$VarPosition" />
      </xsl:attribute>
     </xsl:if>

     <!-- Paragraph -->
     <!--           -->
     <xsl:element name="Paragraph" namespace="{$GlobalDocumentNamespace}">
      <!-- Style -->
      <!--       -->
      <xsl:call-template name="Style">
       <xsl:with-param name="ParamDocument" select="$ParamDocument" />
       <xsl:with-param name="ParamNode" select="$ParamParagraph" />
       <xsl:with-param name="ParamStyleType" select="'Paragraph'" />
      </xsl:call-template>

      <!-- Use numbering? -->
      <!--                -->
      <xsl:variable name="VarUseNumberingOption" select="$VarContextRule/wwproject:Options/wwproject:Option[@Name = 'use-numbering']/@Value" />
      <xsl:variable name="VarUseNumbering" select="(string-length($VarUseNumberingOption) = 0) or ($VarUseNumberingOption = 'true')" />
      <xsl:if test="$VarUseNumbering">
       <xsl:copy-of select="$ParamParagraph/wwdoc:Number" />
      </xsl:if>

      <!-- Copy text run elements -->
      <!--                        -->
      <xsl:for-each select="wwdoc:TextRun">
       <xsl:variable name="VarTextRun" select="." />

       <!-- Create TOC text run -->
       <!--                     -->
       <xsl:element name="TextRun" namespace="{$GlobalDocumentNamespace}">
        <xsl:copy-of select="$VarTextRun/@*" />

        <!-- Style -->
        <!--       -->
        <xsl:call-template name="Style">
         <xsl:with-param name="ParamDocument" select="$ParamDocument" />
         <xsl:with-param name="ParamNode" select="$VarTextRun" />
         <xsl:with-param name="ParamStyleType" select="'Character'" />
        </xsl:call-template>

        <!-- Copy text elements -->
        <!--                    -->
        <xsl:copy-of select="$VarTextRun/wwdoc:Text" />
       </xsl:element>
      </xsl:for-each>
     </xsl:element>

     <xsl:for-each select="$ParamBehaviors[1]">
      <xsl:variable name="VarBehaviorParagraph" select="key('wwbehaviors-paragraphs-by-id', $ParamParagraph/@id)[1]" />
      <xsl:copy-of select="$VarBehaviorParagraph" />
     </xsl:for-each>
    </wwtoc:Entry>
   </xsl:if>
  </xsl:if>
 </xsl:template>


 <xsl:template name="Style">
  <xsl:param name="ParamDocument" />
  <xsl:param name="ParamNode" />
  <xsl:param name="ParamStyleType" />

  <!-- Emit style block -->
  <!--                  -->
  <xsl:choose>
   <xsl:when test="string-length($ParamNode/@stylename) &gt; 0">
    <xsl:element name="Style" namespace="{$GlobalDocumentNamespace}">
     <xsl:for-each select="$ParamDocument[1]">
      <!-- Get Catalog Style -->
      <!--                   -->
      <xsl:variable name="VarDocumentElement" select="$ParamDocument/wwdoc:Document" />
      <xsl:variable name="VarCatalogStyles" select="$VarDocumentElement/wwdoc:Styles/wwdoc:*[starts-with(local-name(), $ParamStyleType)]" />
      <xsl:variable name="VarCatalogStyle" select="$VarCatalogStyles/*[@name = $ParamNode/@stylename]" />

      <xsl:for-each select="$VarCatalogStyle/wwdoc:Style/wwdoc:Attribute">
       <xsl:variable name="VarAttribute" select="." />
       <xsl:variable name="VarOverrideValue" select="$ParamNode/wwdoc:Style/wwdoc:Attribute[@name = $VarAttribute/@name]/@value" />

       <xsl:if test="string-length($VarOverrideValue) = 0">
        <xsl:copy-of select="." />
       </xsl:if>
      </xsl:for-each>
     </xsl:for-each>

     <!-- Get Overrides -->
     <!--               -->
     <xsl:for-each select="$ParamNode/wwdoc:Style/wwdoc:Attribute">
      <xsl:copy-of select="." />
     </xsl:for-each>
    </xsl:element>
   </xsl:when>

   <xsl:when test="count($ParamNode/wwdoc:Style) &gt; 0">
    <!-- Copy as is -->
    <!--            -->
    <xsl:element name="Style" namespace="{$GlobalDocumentNamespace}">
     <xsl:for-each select="$ParamNode/wwdoc:Style/wwdoc:Attribute">
      <xsl:copy-of select="." />
     </xsl:for-each>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
